clear all

* Set Folder to input one

cd ..\Inputs

* Import and clean quarterly tfp data from fernald

import excel "quarterly_tfp.xls", ///
sheet(quarterly) cellrange(A2) firstrow clear

keep date dtfp_util
gen year=substr(date,1,4)
destring year, replace force
gen quarter=substr(date,7,1)
destring quarter, replace force

drop if year==.
drop if dtfp_util==.
drop date

gen t=_n
order t year quarter dtfp_util
rename dtfp_util GTFPF
tsset t

* Generate HP filter

local i=1
foreach lambda of numlist 800(800)4000 5000(5000)20000 25000(50000)325000 ///
                          500000(500000)2000000 4000000(2000000)12000000 {
	di `lambda'
	di `i'
	tsfilter hp hcGT = GTFPF, smooth(`lambda') trend(hpGT`i')
	label var hpGT`i' "hp filtered TFP Fernald, lambda=`lambda'"
	drop hcGT
	local ++i
}

* Generate Moving Averages

forvalues terms=1(1)40 {
	di `terms'
	quietly tssmooth ma maGT`terms'=GTFPF, window(`=`terms'-1' 1 0)
	label var maGT`terms' "MA(`terms') smoothed TFP Fernald"
}

* Change to output folder and save
	   
cd ..\Outputs
save TFPFERNALD, replace
